/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.file;

import com.quantumdata.fmteditor.FmtEditorMain;
import com.quantumdata.fmteditor.InstrumentSource;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.editor.FmtEditorFrame;
import com.quantumdata.fmteditor.file.LoaderSaver;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueType;
import com.quantumdata.fmteditor.fmt.Format;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.xml.DbNode;
import com.quantumdata.std.xml.DbUtil;
import java.io.File;
import java.util.Collection;

public class FmtDataLoader
extends LoaderSaver {
    protected Format m_fmt = null;
    protected boolean m_useNotSave = false;

    public FmtDataLoader() {
    }

    public FmtDataLoader(Format format, InstrumentSource instrumentSource) {
        this.m_isLocal = false;
        this.m_isLoad = false;
        this.m_fmt = format;
        this.m_isrc = instrumentSource;
        this.m_useNotSave = true;
        this.m_fileName = format.getName();
    }

    public FmtDataLoader(String string, InstrumentSource instrumentSource) {
        this.m_isLocal = false;
        this.m_isLoad = true;
        this.m_fileName = string;
        this.m_isrc = instrumentSource;
    }

    private void transfer() {
        RemoteInstrument remoteInstrument;
        this.m_success = false;
        if (this.save() && (remoteInstrument = this.m_isrc.getInstrument()) != null) {
            try {
                remoteInstrument.tryCommand("ERRC;FMTU");
                String string = remoteInstrument.tryQuery("ERRY?");
                int n = Integer.parseInt(string);
                if (n > 0) {
                    this.m_errMsg = "Use failed with error: " + string;
                    this.m_success = false;
                } else {
                    this.m_success = true;
                }
            }
            catch (InstrumentException instrumentException) {
                this.m_errMsg = instrumentException.getMessage();
                this.m_success = false;
            }
        }
        this.callSaveComplete();
    }

    protected void localSave() {
        this.m_fmt = ((FmtEditorFrame)this.m_frame).getFormat();
        String string = this.m_fmt.getName();
        boolean bl = this.m_fmt.isLocal();
        if (this.writeXmlFormat()) {
            this.m_fmt.markUnmodified();
            this.m_success = true;
        } else {
            this.m_fmt.setName(string, bl);
        }
        this.callSaveComplete();
    }

    protected void remoteSave() {
        if (this.m_useNotSave) {
            this.transfer();
            return;
        }
        this.m_fmt = ((FmtEditorFrame)this.m_frame).getFormat();
        this.save();
    }

    private boolean save() {
        String string = this.m_fmt.getName();
        boolean bl = this.m_fmt.isLocal();
        this.m_fmt.setName(this.m_fileName, false);
        if (!this.writeCmdFormat()) {
            this.m_fmt.setName(string, bl);
        } else {
            this.m_fmt.markUnmodified();
            this.m_success = true;
        }
        this.callSaveComplete();
        return this.m_success;
    }

    protected void localLoad() {
        this.m_fmt = new Format();
        if (this.m_file == null) {
            return;
        }
        if (this.checkAndSelectIfOpen(this.m_file.getAbsolutePath())) {
            this.callLoadComplete();
            return;
        }
        this.m_fmt.setName(this.m_file.getAbsolutePath(), true);
        this.m_success = this.readXmlFormat();
        this.m_frame = new FmtEditorFrame(this.m_fmt);
        this.callLoadComplete();
    }

    protected void remoteLoad() {
        this.m_fmt = new Format();
        if (this.m_fileName == null) {
            return;
        }
        this.m_fmt.setName(this.m_fileName, false);
        this.m_success = this.readCmdFormat();
        this.m_frame = new FmtEditorFrame(this.m_fmt);
        this.callLoadComplete();
    }

    protected void saveComplete() {
        if (this.m_useNotSave) {
            if (this.m_success) {
                MsgLog.msg("Used: " + this.m_fmt.getName());
            } else if (this.m_errMsg.length() > 0) {
                MsgLog.error(this.m_errMsg);
            }
            FmtEditorMain.instance().getStatusPanel().hideProgress();
            this.m_isActive = false;
        } else {
            super.saveComplete();
        }
    }

    private boolean readXmlFormat() {
        DbNode dbNode = DbUtil.loadDocument((File)this.m_file, (String)"DATAOBJ");
        if (dbNode == null) {
            MsgLog.error("The file does not have a valid XML Format structure");
            return false;
        }
        DbNode dbNode2 = dbNode.getNode("HEADER");
        if (dbNode2 == null) {
            MsgLog.error("HEADER tag not found");
            return false;
        }
        String string = dbNode2.getAttr("TYPE");
        if (!string.equalsIgnoreCase("fmt")) {
            MsgLog.error("Invalid Type: " + string);
            return false;
        }
        string = dbNode2.getAttr("VERSION");
        if (!string.equalsIgnoreCase("1.0")) {
            MsgLog.error("Invalid version: " + string);
            return false;
        }
        dbNode2 = dbNode.getNode("DATA");
        if (dbNode2 == null) {
            MsgLog.error("DATA tag not found");
            return false;
        }
        for (CmdValue cmdValue : this.m_fmt.getValues()) {
            DbNode dbNode3;
            if (cmdValue.isDerived() || (dbNode3 = dbNode2.getNode(cmdValue.getName())) == null || cmdValue.set(dbNode3.getText())) continue;
            MsgLog.warning("Invalid Parameter value: " + cmdValue.getCmd() + " = " + dbNode3.getText());
        }
        return true;
    }

    private boolean writeXmlFormat() {
        DbNode dbNode = DbUtil.newDocument((String)"DATAOBJ");
        DbNode dbNode2 = dbNode.createChild("HEADER");
        dbNode2.addAttr("TYPE", "FMT");
        dbNode2.addAttr("VERSION", "1.0");
        dbNode2 = dbNode.createChild("DATA");
        for (CmdValue cmdValue : this.m_fmt.getValues()) {
            if (cmdValue.isDerived()) continue;
            if (cmdValue.getType() == CmdValueType.BOOL) {
                dbNode2.addElement(cmdValue.getName(), cmdValue.getBool() ? "TRUE" : "FALSE");
                continue;
            }
            dbNode2.addElement(cmdValue.getName(), cmdValue.get());
        }
        String string = this.m_file.getAbsolutePath().toLowerCase();
        if (!string.endsWith(".xml")) {
            this.m_file = new File(this.m_file.getAbsoluteFile() + ".xml");
        }
        this.m_fmt.setName(this.m_file.getAbsolutePath(), true);
        return DbUtil.saveDocument((DbNode)dbNode, (File)this.m_file);
    }

    private boolean writeCmdFormat() {
        RemoteInstrument remoteInstrument = this.m_isrc.getInstrument();
        try {
            remoteInstrument.tryCommand("FMTN " + this.m_fmt.getName());
            remoteInstrument.tryCommand("FMTB");
            Collection<CmdValue> collection = this.m_fmt.getValues();
            for (CmdValue cmdValue : collection) {
                if (cmdValue.isDerived() || remoteInstrument.command(cmdValue.getCmd() + " " + cmdValue.get()) || cmdValue.isObsolete()) continue;
                MsgLog.error("Unsupported Parameter: " + cmdValue.getCmd());
            }
            if (!this.m_useNotSave) {
                remoteInstrument.tryCommand("FMTS");
            }
            remoteInstrument.tryCommand("FMTE");
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error("Write Failed: " + instrumentException.getMessage());
            return false;
        }
        this.m_fmt.setFromIP(remoteInstrument.getConnection().getName());
        return true;
    }

    private boolean readCmdFormat() {
        RemoteInstrument remoteInstrument = this.m_isrc.getInstrument();
        if (!remoteInstrument.command("FMTL " + this.m_fileName + " 1")) {
            MsgLog.error("Unable to load format: " + this.m_fileName);
            return false;
        }
        this.m_fmt.setName(remoteInstrument.query("FMTL?"), false);
        this.m_fmt.setFromIP(remoteInstrument.getConnection().getName());
        Collection<CmdValue> collection = this.m_fmt.getValues();
        for (CmdValue cmdValue : collection) {
            if (cmdValue.isDerived()) continue;
            String string = remoteInstrument.query(cmdValue.getCmd() + "?");
            if (string != null) {
                if (cmdValue.set(string)) continue;
                MsgLog.warning("Invalid Parameter value: " + cmdValue.getCmd() + " = " + string);
                continue;
            }
            if (!cmdValue.isObsolete()) {
                this.m_errMsg = "Invalid Parameter: " + cmdValue.getCmd();
                return false;
            }
            MsgLog.msg(cmdValue.getCmd() + " not found: using the default value");
        }
        return true;
    }
}

